from flask import request
from flask_admin.contrib.sqla import ModelView
from flask_admin.contrib.sqla.filters import FilterEqual
from travel.rasp.bus.db import session_scope
from travel.rasp.bus.db.models.matching import PointMatching, PointMatchingLog
from travel.rasp.bus.db.models.supplier import Supplier
from travel.rasp.bus.roles import ROLES
from travel.rasp.bus.admin.app.views.principal import PrincipalViewMixin


def _get_supplier_filter_options():
    if not request:
        return
    with session_scope() as session:
        return [(s.id, s.code) for s in session.query(Supplier)]


class PointMatchingLogsView(PrincipalViewMixin, ModelView):
    can_create = False
    can_delete = False
    can_edit = False
    can_view_details = False
    page_size = 50
    can_set_page_size = True
    edit_modal = False
    named_filter_urls = True

    accessible_for = [ROLES.Admin, ROLES.PointMatching]

    column_labels = {
        'point_matching.supplier_point_id': 'Supplier point ID',
        'point_matching.supplier.code': 'Supplier',
    }

    column_list = [
        'point_matching.supplier.code',
        'point_matching.supplier_point_id',
        'action',
        'changes',
        'log_time',
        'author',
    ]

    column_searchable_list = [
        'changes',
    ]

    column_default_sort = ('log_time', True)

    column_filters = [
        FilterEqual(column=PointMatching.supplier_id, name='Supplier', options=_get_supplier_filter_options),
        FilterEqual(column=PointMatching.supplier_point_id, name='Supplier Point Id'),
        FilterEqual(column=PointMatchingLog.author, name='Author'),
    ]

    def get_list(self, *args, **kwargs):
        self._refresh_filters_cache()
        return super().get_list(*args, **kwargs)
