from flask import g
from travel.rasp.bus.roles import ROLES


class PrincipalViewMixin:

    accessible_for = [ROLES.Admin]

    def is_accessible(self):
        return any(r.permission.allows(g.identity) for r in self.accessible_for)
