from flask_admin.contrib.sqla import ModelView

from travel.rasp.bus.admin.app.views.principal import PrincipalViewMixin


class RegisterTypeView(PrincipalViewMixin, ModelView):
    can_create = True
    can_delete = True
    form_excluded_columns = ('created_at', 'updated_at',)
    column_labels = {
        'id': 'id',
        'code': 'Код',
        'title': 'Название',
        'description': 'Описание',
        'created_at': 'Время создание',
        'updated_at': 'Время обновление',
    }
