from flask_admin.contrib.sqla import ModelView

from travel.rasp.bus.admin.app.views.principal import PrincipalViewMixin


class SupplierView(PrincipalViewMixin, ModelView):
    can_create = True
    can_delete = True
    form_excluded_columns = ('created_at', 'updated_at',)

    column_labels = {
        'id': 'id',
        'code': 'Код',
        'name': 'Название',
        'register_type': 'Рег. тип',
        'register_number': 'Рег. номер',
        'legal_name': 'Юридическое название',
        'actual_address': 'Фактический адрес',
        'legal_address': 'Юридический адрес',
        'timetable': 'Время работы',
        'taxation_number': 'ИНН',
        'first_name': 'Имя',
        'middle_name': 'Отчество',
        'last_name': 'Фамилия',
        'description': 'Описание',
        'hidden': 'Скрыт',
        'created_at': 'Время создание',
        'updated_at': 'Время обновление',
    }

    column_list = (
        'id', 'code', 'name', 'legal_name',
        'register_type', 'register_number',
        'actual_address', 'legal_address', 'timetable', 'taxation_number',
        'last_name', 'first_name', 'middle_name',
        'hidden',
        'created_at', 'updated_at',
    )
