# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

from logging.config import fileConfig

from alembic import context
from flask import current_app
from sqlalchemy import engine_from_config, pool

# this is the Alembic Config object, which provides
# access to the values within the .ini file in use.
config = context.config

# Interpret the config file for Python logging.
# This line sets up loggers basically.
fileConfig(config.config_file_name)

config.set_main_option('sqlalchemy.url',
                       str(current_app.config.get('SQLALCHEMY_DATABASE_URI')))
config.set_main_option('buses.url',
                       str(current_app.config.get('SQLALCHEMY_DATABASE_URI')))

target_metadata = [
    current_app.extensions['migrate'].db.metadata,
]  # other values from the config, defined by the needs of env.py,


exclude_tables = {s.strip() for s in config.get_section('alembic:exclude').get('tables', '').split(',')}
exclude_indexes = {s.strip() for s in config.get_section('alembic:exclude').get('indexes', '').split(',')}


def include_object(object, name, type_, reflected, compare_to):
    if type_ == 'table' and object.schema not in ['buses', 'point_matching', 'public']:
        return False
    if type_ == 'table' and name in exclude_tables:
        return False
    elif type_ == 'index' and name in exclude_indexes:
        return False
    else:
        return True


def run_migrations_offline():
    """Run migrations in 'offline' mode.

    This configures the context with just a URL
    and not an Engine, though an Engine is acceptable
    here as well.  By skipping the Engine creation
    we don't even need a DBAPI to be available.

    Calls to context.execute() here emit the given string to the
    script output.

    """
    url = config.get_main_option('sqlalchemy.url')
    context.configure(
        url=url,
        target_metadata=target_metadata,
        literal_binds=True,
        include_object=include_object,
        transaction_per_migration=True,
        version_table_schema='system',
    )

    context.run_migrations()


def run_migrations_online():
    """Run migrations in 'online' mode.

    In this scenario we need to create an Engine
    and associate a connection with the context.

    """

    connectable = engine_from_config(
        config.get_section(config.config_ini_section),
        prefix='sqlalchemy.',
        poolclass=pool.NullPool)

    with connectable.connect() as connection:
        context.configure(
            connection=connection,
            target_metadata=target_metadata,
            compare_type=True,
            include_object=include_object,
            include_schemas=True,
            transaction_per_migration=True,
            version_table='contol_version',
            version_table_schema='system',
            # process_revision_directives=process_revision_directivesuj
            **current_app.extensions['migrate'].configure_args
        )

        context.run_migrations()


if context.is_offline_mode():
    run_migrations_offline()
else:
    run_migrations_online()
