"""init_database

Revision ID: c5976533b4d3
Revises:
Create Date: 2019-03-18 14:53:36.400484

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'c5976533b4d3'
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('register_type',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('code', sa.String(), nullable=False),
    sa.Column('title', sa.String(), nullable=False),
    sa.Column('description', sa.String(), nullable=False),
    sa.Column('created_at', sa.DateTime(), server_default=sa.text(u'now()'), nullable=False),
    sa.Column('updated_at', sa.DateTime(), server_default=sa.text(u'now()'), nullable=False),
    sa.PrimaryKeyConstraint('id'),
    schema='buses'
    )
    op.create_table('carrier',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(), nullable=False),
    sa.Column('register_type_id', sa.Integer(), nullable=False),
    sa.Column('register_number', sa.String(), nullable=False),
    sa.Column('legal_name', sa.String(), nullable=False),
    sa.Column('actual_address', sa.String(), nullable=False),
    sa.Column('legal_address', sa.String(), nullable=False),
    sa.Column('timetable', sa.String(), nullable=False),
    sa.Column('first_name', sa.String(), nullable=False),
    sa.Column('middle_name', sa.String(), nullable=False),
    sa.Column('last_name', sa.String(), nullable=False),
    sa.Column('hidden', sa.Boolean(), nullable=False),
    sa.Column('created_at', sa.DateTime(), server_default=sa.text(u'now()'), nullable=False),
    sa.Column('updated_at', sa.DateTime(), server_default=sa.text(u'now()'), nullable=False),
    sa.ForeignKeyConstraint(['register_type_id'], [u'buses.register_type.id'], ),
    sa.PrimaryKeyConstraint('id'),
    schema='buses'
    )
    op.create_table('supplier',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('code', sa.String(), nullable=False),
    sa.Column('name', sa.String(), nullable=False),
    sa.Column('register_type_id', sa.Integer(), nullable=False),
    sa.Column('register_number', sa.String(), nullable=False),
    sa.Column('legal_name', sa.String(), nullable=False),
    sa.Column('actual_address', sa.String(), nullable=False),
    sa.Column('legal_address', sa.String(), nullable=False),
    sa.Column('timetable', sa.String(), nullable=False),
    sa.Column('first_name', sa.String(), nullable=False),
    sa.Column('middle_name', sa.String(), nullable=False),
    sa.Column('last_name', sa.String(), nullable=False),
    sa.Column('hidden', sa.Boolean(), nullable=False),
    sa.Column('created_at', sa.DateTime(), server_default=sa.text(u'now()'), nullable=False),
    sa.Column('updated_at', sa.DateTime(), server_default=sa.text(u'now()'), nullable=False),
    sa.ForeignKeyConstraint(['register_type_id'], [u'buses.register_type.id'], ),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('code', name=u'supplier_unq_index'),
    schema='buses'
    )
    op.create_table('carriermatching',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('supplier_id', sa.Integer(), nullable=False),
    sa.Column('code', sa.String(), nullable=False),
    sa.Column('carrier_id', sa.Integer(), nullable=False),
    sa.Column('created_at', sa.DateTime(), server_default=sa.text(u'now()'), nullable=False),
    sa.Column('updated_at', sa.DateTime(), server_default=sa.text(u'now()'), nullable=False),
    sa.ForeignKeyConstraint(['carrier_id'], [u'buses.carrier.id'], ),
    sa.ForeignKeyConstraint(['supplier_id'], [u'buses.supplier.id'], ),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('code'),
    sa.UniqueConstraint('supplier_id', 'code', name=u'matching_unq_index'),
    schema='buses'
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('carriermatching', schema='buses')
    op.drop_table('supplier', schema='buses')
    op.drop_table('carrier', schema='buses')
    op.drop_table('register_type', schema='buses')
    # ### end Alembic commands ###
