# coding: utf8
"""init_register_type

Revision ID: 60fbb06f93f8
Revises: c5976533b4d3
Create Date: 2019-03-18 14:56:48.409187

"""
from alembic import op
from sqlalchemy import orm

from travel.rasp.bus.db.models.register_type import RegisterType


# revision identifiers, used by Alembic.
revision = '60fbb06f93f8'
down_revision = 'c5976533b4d3'
branch_labels = None
depends_on = None


def upgrade():
    bind = op.get_bind()
    session = orm.Session(bind=bind)

    session.add(RegisterType(
        code=u'ОГРН',
        title=u'Основной государственный регистрационный номер',
        description='',
    ))
    session.add(RegisterType(
        code=u'ОГРНИП',
        title=u'Основной государственный регистрационный номер индивидуального предпринимателя',
        description='',
    ))

    session.commit()


def downgrade():
    bind = op.get_bind()
    session = orm.Session(bind=bind)

    session.query(RegisterType).delete()

    session.commit()
