"""create auth models

Revision ID: 0381cc770d00
Revises: 60fbb06f93f8
Create Date: 2019-03-22 11:23:56.830463

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = '0381cc770d00'
down_revision = '60fbb06f93f8'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('admin_users',
    sa.Column('login', sa.Text(), nullable=False),
    sa.Column('created_at', sa.DateTime(), server_default=sa.text(u'now()'), nullable=False),
    sa.Column('updated_at', sa.DateTime(), server_default=sa.text(u'now()'), nullable=False),
    sa.PrimaryKeyConstraint('login'),
    schema='buses'
    )
    op.create_table('admin_user_roles',
    sa.Column('name', postgresql.ENUM('Admin', name='policy_role'), nullable=False),
    sa.Column('yandex_login', sa.Text(), nullable=False),
    sa.Column('is_active', sa.Boolean(), nullable=False),
    sa.Column('created_at', sa.DateTime(), server_default=sa.text(u'now()'), nullable=False),
    sa.Column('updated_at', sa.DateTime(), server_default=sa.text(u'now()'), nullable=False),
    sa.ForeignKeyConstraint(['yandex_login'], [u'buses.admin_users.login'], ),
    sa.PrimaryKeyConstraint('yandex_login', 'name'),
    schema='buses'
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('admin_user_roles', schema='buses')
    op.drop_table('admin_users', schema='buses')
    # ### end Alembic commands ###
