"""add_point_matching_table

Revision ID: bf2a79aad1b4
Revises: 54dbc07fc5ef
Create Date: 2019-07-15 18:41:14.290589

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'bf2a79aad1b4'
down_revision = '54dbc07fc5ef'
branch_labels = None
depends_on = None


def upgrade():
    op.execute("create schema point_matching")
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('point_matching',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('supplier_id', sa.Integer(), nullable=False),
    sa.Column('supplier_point_id', sa.Text(), nullable=False),
    sa.Column('parent_id', sa.Integer(), nullable=True),
    sa.Column('type', sa.Enum('CITY', 'STATION', 'INVALID', name='pointtype'), nullable=True),
    sa.Column('title', sa.Text(), nullable=False),
    sa.Column('description', sa.Text(), nullable=True),
    sa.Column('latitude', sa.Float(), nullable=True),
    sa.Column('longitude', sa.Float(), nullable=True),
    sa.Column('country', sa.Text(), nullable=True),
    sa.Column('point_key', sa.Text(), nullable=True),
    sa.Column('created_at', sa.DateTime(), server_default=sa.text('now()'), nullable=False),
    sa.Column('updated_at', sa.DateTime(), server_default=sa.text('now()'), nullable=False),
    sa.Column('updated_by_login', sa.Text(), nullable=False),
    sa.ForeignKeyConstraint(['parent_id'], ['point_matching.point_matching.id'], ),
    sa.ForeignKeyConstraint(['supplier_id'], ['buses.supplier.id'], ),
    sa.ForeignKeyConstraint(['updated_by_login'], ['buses.admin_users.login'], ),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('supplier_id', 'supplier_point_id', name='point_matching_ukey'),
    schema='point_matching'
    )
    op.create_index('point_matching_point_key_idx', 'point_matching', ['point_key'], unique=False, schema='point_matching')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index('point_matching_point_key_idx', table_name='point_matching', schema='point_matching')
    op.drop_table('point_matching', schema='point_matching')
    # ### end Alembic commands ###
    op.execute("drop schema point_matching")
