"""add pointmatching admin role

Revision ID: 447aac0a1680
Revises: 71c106cfe24e
Create Date: 2019-12-27 17:47:16.150246

"""
from contextlib import contextmanager

from alembic import op

# revision identifiers, used by Alembic.
revision = '447aac0a1680'
down_revision = '71c106cfe24e'
branch_labels = None
depends_on = None


@contextmanager
def autocommit_block():
    # pre 1.2.0 version of autocommit_block
    connection = current_level = None

    if not op.get_context().as_sql:
        connection = op.get_bind()
        current_level = connection.get_isolation_level()
        connection.execution_options(isolation_level='AUTOCOMMIT')

    try:
        yield
    finally:
        if connection is not None:
            connection.execution_options(isolation_level=current_level)


def upgrade():
    with autocommit_block():
        op.execute("ALTER TYPE policy_role ADD VALUE IF NOT EXISTS 'PointMatching'")


def downgrade():
    pass
