"""empty message

Revision ID: 3e1757728429
Revises: 8145eaa2c3a6
Create Date: 2020-09-15 15:29:36.933769

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = '3e1757728429'
down_revision = '8145eaa2c3a6'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('point_matching_logs',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('point_matching_id', sa.Integer(), nullable=False),
    sa.Column('action', sa.Text(), nullable=True),
    sa.Column('changes', postgresql.JSONB(astext_type=sa.Text()), nullable=False),
    sa.Column('log_time', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('author', sa.Text(), nullable=False),
    sa.ForeignKeyConstraint(['point_matching_id'], ['point_matching.point_matching.id'], ),
    sa.PrimaryKeyConstraint('id'),
    schema='point_matching'
    )
    op.create_index('point_matching_logs_pm_id_idx', 'point_matching_logs', ['point_matching_id'], unique=False, schema='point_matching')
    op.drop_table('outdated_changes', schema='point_matching')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('outdated_changes',
    sa.Column('point_matching_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('state', sa.BOOLEAN(), autoincrement=False, nullable=False),
    sa.Column('changed_at', postgresql.TIMESTAMP(), autoincrement=False, nullable=False),
    sa.ForeignKeyConstraint(['point_matching_id'], ['point_matching.point_matching.id'], name='outdated_changes_point_matching_id_fkey'),
    sa.PrimaryKeyConstraint('point_matching_id', 'changed_at', name='outdated_changes_pkey'),
    schema='point_matching'
    )
    op.drop_index('point_matching_logs_pm_id_idx', table_name='point_matching_logs', schema='point_matching')
    op.drop_table('point_matching_logs', schema='point_matching')
    # ### end Alembic commands ###
