import pickle

import redis

from travel.rasp.bus.settings import Settings


def _create_redis_client():
    return redis.Redis(host=Settings.CarriersCache.REDIS_HOST, port=Settings.CarriersCache.REDIS_PORT)


def load_carriers(carrier_type, carrier_code):
    redis_client = _create_redis_client()
    carriers_dump = redis_client.get(
        f'carrier_search:{carrier_type.value}:{carrier_code}'
    )
    if carriers_dump is not None:
        return pickle.loads(carriers_dump)


def dump_carriers(carrier_type, carrier_code, carriers):
    redis_client = _create_redis_client()
    redis_client.set(
        f'carrier_search:{carrier_type.value}:{carrier_code}',
        pickle.dumps(carriers),
        ex=int(Settings.CarriersCache.TIMEOUT.total_seconds())
    )
