
import json
from datetime import datetime
from http.cookies import SimpleCookie
from wsgiref.headers import Headers

from dateutil.tz import tzlocal
from flask import g
from gunicorn.glogging import Logger

from travel.rasp.bus.library.logbroker_client import LogBrokerClient


class GunicornLogger(Logger):

    def __init__(self, cfg):
        super().__init__(cfg)
        self.lb = LogBrokerClient()

    def access(self, resp, req, environ, request_time):
        super().access(resp, req, environ, request_time)
        if not self.lb.enabled:
            return
        headers = Headers(req.headers)
        yandex_login, yandexuid = None, None
        if 'COOKIE' in headers:
            cookie = SimpleCookie()
            cookie.load(headers['COOKIE'])
            if 'yandex_login' in cookie:
                yandex_login = cookie['yandex_login'].value
            if 'yandexuid' in cookie:
                yandexuid = cookie['yandexuid'].value
        msg = {
            'time': datetime.now(tz=tzlocal()).strftime('%d/%b/%Y:%H:%M:%S %z'),
            'user': g.identity.id if g else None,
            'yandex_login': yandex_login,
            'yandexuid': yandexuid,
            'http_user_agent': environ.get('HTTP_USER_AGENT'),
            'http_referrer': environ.get('HTTP_REFERER'),
            'src_ip': environ.get('HTTP_X_FORWARDED_FOR'),
            'request': '{} {} {}'.format(req.method, req.uri, environ.get('SERVER_PROTOCOL')),
            'status': resp.status_code,
            'byte': resp.sent,
            'request_time': request_time.microseconds // 1000,
        }
        self.lb.publish(json.dumps(msg).encode())
