import logging

import requests
from requests.compat import urljoin

from travel.rasp.bus.settings import Settings


class SuggestClient:
    """Transparent client for go_suggests"""

    @staticmethod
    def _get(search_type, params, raise_exception=False, default=None):
        try:
            resp = requests.get(urljoin(Settings.PointMatchingSuggest.URL, search_type), params=params)
            resp.raise_for_status()
        except requests.exceptions.RequestException as e:
            logging.error('Can not fetch suggest: %r', e)
            if raise_exception:
                raise e
            else:
                return default
        return resp.json()

    @classmethod
    def search(cls, query, limit=10):
        resp = cls._get('search', {'text': query, 'limit': limit}, default={})
        items = resp.get('items', [])
        return items

    @classmethod
    def get_by_point_key(cls, query):
        resp = cls._get('pointkey', {'query': query}, default={})
        suggests = resp.get('suggests')
        if suggests is None:
            logging.error('Format error: no suggests')
            return None
        if len(suggests) != 1:
            if len(suggests) > 1:
                logging.error('Multiple result for pointkey=%r search', query)
            return None
        suggest = suggests[0]
        if 'full_title' not in suggest:
            logging.error('Format error: no full_title')
            return None
        return suggests[0]
