# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

from flask_restful import fields

from travel.rasp.bus.api.connectors.entities.entity import Entity
from travel.rasp.bus.api.connectors.fields.fields import Optional, Required
from travel.rasp.bus.api.connectors.fields.validation import Validatable, ValidationError


class Endpoint(Entity):
    class Type(fields.Raw, Validatable):
        enum = {'city', 'station'}

        def output(self, key, obj):
            return self.format(fields.get_value(
                key if self.attribute is None else self.attribute, obj
            ))

        def validate(self, value, path):
            if value not in self.enum:
                return [ValidationError(path, "is not valid: must be one of {}".format(self.enum))]
            return []

    fields = {
        'supplier_id': Required(fields.Raw),
        'type': Required(Type),
        'title': Required(fields.Raw),
        'description': Optional(fields.Raw),
        'latitude': Optional(fields.Float),
        'longitude': Optional(fields.Float),
        'country': Optional(fields.Raw),
        'city_id': Optional(fields.Raw),
        'country_code': Optional(fields.String),
        'city_title': Optional(fields.String),
        'region': Optional(fields.String),
        'region_code': Optional(fields.String),
        'district': Optional(fields.String),
        'extra_info': Optional(fields.String),
        'timezone_info': Optional(fields.String),
    }
