# -*- coding: utf-8 -*-

from travel.rasp.bus.api.connectors.fields.validation import Validatable, ValidationWarning

from flask_restful import fields


__all__ = ['converter', 'id_wrapper', 'mk_id_name_field']


def converter(cls):
    super_format = cls.format

    def variants(cls):
        if isinstance(cls.conv, dict):
            obj = cls()
            return [(v, obj.format(v)) for v in cls.conv]
        return []

    def format(self, value):
        conv = self.conv if callable(self.conv) else self.conv.get
        return super_format(self, conv(value))

    cls.format = format
    cls.variants = classmethod(variants)
    return cls


def id_wrapper(id_cls):
    """Decorator factory to wrap return value of output method of some field
       class with identifier dumps method.
        :param id_cls: wrapping class :class:`yabus.common.identifiers.Identifier`
        :return: decorator that takes :class:`flask_restful.fields.Raw` class,
         which output method returns dict, and modifies field output method,
         wrapping its return value with identifier dumps method

        .. seealso::
            * :class:`yabus.common.identifiers.Identifier`
    """
    def decorator(cls):
        cls.id_wrapper = id_cls
        super_output = cls.output

        def output(self, key, obj):
            values = super_output(self, key, obj)
            return id_cls(**values).dumps()

        cls.output = output
        return cls

    return decorator


def mk_id_name_field(table, default_id=None):
    class Field(fields.Raw, Validatable):
        def format(self, value):
            if value not in table:
                return self.default
            return {
                'id': value,
                'name': table[value],
            }

        def validate(self, value, path):
            checks = [('id', table.keys()), ('name', table.values())]
            return [
                ValidationWarning(path + [k], "must be one of {}, got {}".format(enum, value.get(k)))
                for k, enum in checks if value.get(k) not in enum
            ]

    return Field
