# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

from contextlib import contextmanager

from sqlalchemy import create_engine
from sqlalchemy.orm import sessionmaker
from sqlalchemy.pool import NullPool

from travel.rasp.bus.settings import Settings


engine = create_engine(Settings.SQLALCHEMY_DATABASE_URI, poolclass=NullPool)

# create a Session
Session = sessionmaker(bind=engine)


@contextmanager
def session_scope(**kwargs):
    """Provide a transactional scope around a series of operations."""
    session = Session(**kwargs)
    try:
        yield session
        session.commit()
    except:
        session.rollback()
        raise
    finally:
        session.close()
