# coding=utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

from sqlalchemy import Boolean, Column, DateTime, ForeignKey, func, PrimaryKeyConstraint, Text
from sqlalchemy.dialects.postgresql import ENUM
from sqlalchemy.orm import relationship

from travel.rasp.bus.db.models.shared import Base, instance_repr
from travel.rasp.bus.roles import ROLES


class AdminUserRole(Base):
    __tablename__ = 'admin_user_roles'
    __table_args__ = (
        PrimaryKeyConstraint('yandex_login', 'name'),
    )

    name = Column(ENUM(*ROLES.__dict__.keys(), name='policy_role'))

    yandex_login = Column(ForeignKey('admin_users.login'), nullable=False)
    user = relationship('AdminUser', back_populates='roles', uselist=False)

    is_active = Column(Boolean, nullable=False, default=True)

    created_at = Column(DateTime, nullable=False, server_default=func.now())
    updated_at = Column(DateTime, nullable=False, server_default=func.now(), onupdate=func.now())

    def __init__(self, user, name):
        self.user = user
        self.name = name

    def __str__(self):
        return '{} - {}'.format(self.yandex_login, self.name)

    def __repr__(self):
        return instance_repr(self, ('name', 'yandex_login', 'is_active'))


class AdminUser(Base):
    __tablename__ = 'admin_users'

    login = Column(Text, primary_key=True)

    roles = relationship('AdminUserRole', back_populates='user')

    created_at = Column(DateTime, nullable=False, server_default=func.now())
    updated_at = Column(DateTime, nullable=False, server_default=func.now(), onupdate=func.now())

    def __init__(self, login):
        self.login = login

    def __str__(self):
        return self.login

    def __repr__(self):
        return instance_repr(self, ('login', 'updated_at'))
