# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import six
from sqlalchemy import Boolean, Column, DateTime, ForeignKey, Integer, String, UniqueConstraint, func
from sqlalchemy.orm import relationship

from travel.rasp.bus.db.models.shared import Base, instance_repr


@six.python_2_unicode_compatible
class Carrier(Base):
    __tablename__ = 'carrier'

    id = Column(Integer, primary_key=True)
    name = Column(String)  # TODO: delete me

    register_type_id = Column(Integer, ForeignKey('register_type.id'), nullable=False)
    register_type = relationship('RegisterType', foreign_keys=[register_type_id])
    register_number = Column(String, nullable=False)

    inn = Column(String)

    legal_name = Column(String, nullable=False, default='')
    actual_address = Column(String, nullable=False, default='')
    legal_address = Column(String, nullable=False, default='')
    timetable = Column(String, nullable=False, default='')

    first_name = Column(String, nullable=False, default='')
    middle_name = Column(String, nullable=False, default='')
    last_name = Column(String, nullable=False, default='')

    hidden = Column(Boolean, nullable=False, default=True)

    created_at = Column(DateTime, nullable=False, server_default=func.now())
    updated_at = Column(DateTime, nullable=False, server_default=func.now(), onupdate=func.now())

    __table_args__ = (
        UniqueConstraint(register_number, register_type_id, name='carrier_register_unq_index'),
        UniqueConstraint(inn, name='carrier_inn_unq_index'),
    )

    def __repr__(self):
        return instance_repr(self, ('id', 'register_type', 'register_number'))

    def __str__(self):
        return self.legal_name or ' '.join(filter(None, (self.last_name, self.first_name, self.middle_name)))
