# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

from sqlalchemy import Column, DateTime, ForeignKey, func, Integer, String, UniqueConstraint
from sqlalchemy.orm import relationship

from travel.rasp.bus.db.models.shared import Base, instance_repr


class CarrierMatching(Base):
    __table_name__ = 'carrier_matching'

    id = Column(Integer, primary_key=True)

    supplier_id = Column(Integer, ForeignKey('supplier.id'), nullable=False)
    supplier = relationship('Supplier', foreign_keys=[supplier_id])

    code = Column(String, nullable=False)

    carrier_id = Column(Integer, ForeignKey('carrier.id'), nullable=False)
    carrier = relationship('Carrier', foreign_keys=[carrier_id])

    created_at = Column(DateTime, nullable=False, server_default=func.now())
    updated_at = Column(DateTime, nullable=False, server_default=func.now(), onupdate=func.now())

    __table_args__ = (
        UniqueConstraint(code, supplier_id, carrier_id, name='matching_unq_index'),
    )

    def __repr__(self):
        return instance_repr(self, ('code', 'supplier.code'))
