# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

from sqlalchemy import Boolean, Column, Integer, JSON, PrimaryKeyConstraint, String, Text, TIMESTAMP, UniqueConstraint
from sqlalchemy.dialects.postgresql import JSONB
from sqlalchemy.orm import relationship

from travel.rasp.bus.db.models.shared import Base


class Order(Base):
    __tablename__ = 'orders'

    id = Column(String(length=40))
    status = Column(Text)
    ride = Column(JSON, nullable=False)
    booking = Column(JSON, nullable=False)
    contacts = Column(JSON, nullable=False)
    purchase = Column(JSON)
    uid = Column(Text)
    tld = Column(Text)
    refund_application = Column(JSON)
    feedback_letter_sent = Column(Boolean)
    short_id = Column(String(length=7))
    promocode = Column(String(length=255))
    promocode_application_id = Column(Integer)
    creation_ts = Column(TIMESTAMP)
    tracking = Column(JSON)
    billing_log = Column(JSONB)

    log_entries = relationship('OrderLogEntry', back_populates='order')

    __table_args__ = (
        PrimaryKeyConstraint(id, name='orders_pkey'),
        UniqueConstraint(short_id, name='orders_short_id_key'),
        {
            'schema': 'public',
        },
    )
