# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

from sqlalchemy import BigInteger, Column, ForeignKey, String, Text
from sqlalchemy.orm import relationship

from travel.rasp.bus.db.models.shared import Base


class OrderLogEntry(Base):
    __tablename__ = "orders_log"

    order_id = Column(String(length=40), ForeignKey("public.orders.id"), name="id", nullable=False, primary_key=True)
    order = relationship("Order", back_populates="log_entries")

    status = Column(Text)
    log = Column(Text)
    timestamp = Column(BigInteger, primary_key=True)

    __table_args__ = ({"schema": "public"},)
