# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import six
from sqlalchemy import Column, DateTime, func, Integer, String

from travel.rasp.bus.db.models.shared import Base, instance_repr


@six.python_2_unicode_compatible
class RegisterType(Base):
    __tablename__ = 'register_type'

    id = Column(Integer, primary_key=True)
    code = Column(String, nullable=False)
    title = Column(String, nullable=False, default='')
    description = Column(String, nullable=False, default='')

    created_at = Column(DateTime, nullable=False, server_default=func.now())
    updated_at = Column(DateTime, nullable=False, server_default=func.now(), onupdate=func.now())

    def __repr__(self):
        return instance_repr(self, ('id', 'code'))

    def __str__(self):
        return self.code
