# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

from six.moves import reduce
from sqlalchemy import MetaData
from sqlalchemy.ext.declarative import as_declarative, declared_attr


def instance_repr(instance, attribute_names=None):
    if attribute_names is None:
        attribute_names = [attribute_name for attribute_name in dir(instance) if not attribute_name.startswith('_')]

    return '<{class_name} {attributes}>'.format(
        class_name=instance.__class__.__name__,
        attributes=' '.join(
            '{}={!r}'.format(attribute_name, reduce(getattr, attribute_name.split('.'), instance))
            for attribute_name in attribute_names
        )
    )


metadata = MetaData(schema='buses')


@as_declarative(metadata=metadata)
class Base(object):
    @declared_attr
    def __tablename__(cls):
        return cls.__name__.lower()
