# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

from sqlalchemy import Column, JSON, PrimaryKeyConstraint, Text

from travel.rasp.bus.db.models.shared import Base

storage_primary_key = PrimaryKeyConstraint('key', name='storage_pkey')


class Storage(Base):
    __tablename__ = 'storage'

    key = Column(Text, primary_key=True)
    value = Column(JSON)

    __table_args__ = (
        storage_primary_key,
        {
            'schema': 'yabus',
        },
    )
