# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

import locale


class LocaleHolder(object):
    def __init__(self, necessary_locale):
        self._necessary_locale = necessary_locale
        self._current_locale = None

    def __enter__(self):
        self._current_locale = locale.getlocale()
        locale.setlocale(locale.LC_ALL, self._necessary_locale)

    def __exit__(self, type, value, traceback):
        locale.setlocale(locale.LC_ALL, self._current_locale)
        self._current_locale = None


class RuLocaleHolder(LocaleHolder):
    def __init__(self):
        super(RuLocaleHolder, self).__init__(('RU', 'UTF8'))
