import logging
import typing

import requests
import yarl

log = logging.getLogger(__name__)


class Client:
    def __init__(self, api_url: str, service_token: str):
        self._api = yarl.URL(api_url)
        self._headers = {"X-Service-Token": service_token}

    def get_payment_data(self, purchase_token: str) -> typing.Dict[str, typing.Any]:
        response = requests.get(str(self._api / "payments" / purchase_token), headers=self._headers)
        response.raise_for_status()
        payment_data = response.json()
        assert isinstance(payment_data, dict)
        log.debug("payment_data: %r", payment_data)
        assert payment_data["status"] == "success"
        return payment_data

    def clear_payment(self, purchase_token: str) -> None:
        response = requests.post(str(self._api / "payments" / purchase_token / "clear"), headers=self._headers, json={})
        response.raise_for_status()
        clear_data = response.json()
        log.debug("clear_data: %r", clear_data)
        assert clear_data["status"] == "success"
