from flask import request
from tvm2 import TVM2


class TvmChecker(TVM2):
    """
    TVM2 wrapper for flask
    """

    def check_request_ticket(self):
        ticket = request.headers.get('X-Ya-Service-Ticket')
        if not ticket:
            return False
        parsed_ticket = self.parse_service_ticket(ticket=ticket)
        if parsed_ticket:
            return True
        return False
