# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import click
from flask.cli import FlaskGroup

from travel.rasp.bus.morda_backend.app import app

cli = FlaskGroup(create_app=lambda: app)


@cli.command()
@click.option('--bind', '-b', type=str, default='[::]:5000', help='Bind', show_default=True)
@click.option('--workers', '-w', type=int, default=4, help='Number of workers to spawn', show_default=True)
def gunicorn(bind, workers):
    """Start the Server with Gunicorn"""
    from gunicorn.app.base import BaseApplication

    class FlaskApplication(BaseApplication):
        def __init__(self):
            self.options = {
                'bind': bind,
                'workers': workers,
            }
            super(FlaskApplication, self).__init__()

        def load_config(self):
            config = dict([(key, value) for key, value in self.options.items()
                           if key in self.cfg.settings and value is not None])
            config = dict([(key, value) for key, value in self.options.items()
                           if key in self.cfg.settings and value is not None])
            for key, value in config.items():
                self.cfg.set(key.lower(), value)

        def load(self):
            return app

    application = FlaskApplication()
    return application.run()


if __name__ == '__main__':
    cli()
