# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import yenv
from flask import Flask
from flask_restful import Api
from flask_sqlalchemy import SQLAlchemy

from travel.rasp.bus import settings
from travel.rasp.bus.db.models.shared import metadata
from travel.rasp.bus.morda_backend.views.carrier import CarrierListRoute, CarrierRoute
from travel.rasp.bus.morda_backend.views.carrier_matching import CarrierMatchingListRoute, CarrierMatchingSearchRoute
from travel.rasp.bus.morda_backend.views.supplier import SupplierListRoute, SupplierRoute

app = Flask(__name__)
api = Api(app)

app.config.from_object(settings)
db = SQLAlchemy(metadata=metadata)
db.init_app(app)

api.add_resource(CarrierRoute, '/api/carriers/<id>')
api.add_resource(CarrierListRoute, '/api/carriers/')

api.add_resource(SupplierRoute, '/api/suppliers/<id>')
api.add_resource(SupplierListRoute, '/api/suppliers/')

api.add_resource(CarrierMatchingSearchRoute, '/api/carrier-matchings/search/')
api.add_resource(CarrierMatchingListRoute, '/api/carrier-matchings/')


@app.context_processor
def injects_yenv():
    return dict(yenv_type=yenv.type)


@app.route('/ping')
def ping():
    return 'pong'
