# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

from flask_restful import abort, marshal, Resource

from travel.rasp.bus.db import session_scope
from travel.rasp.bus.db.models.carrier import Carrier
from travel.rasp.bus.morda_backend.views.organization import organization_fields


class CarrierListRoute(Resource):
    def get(self):
        '''List all carrier'''
        with session_scope() as session:
            items = marshal(session.query(Carrier).all(), organization_fields)
        return items


class CarrierRoute(Resource):
    def get(self, id):
        '''Fetch a carrier given its identifier'''
        with session_scope() as session:
            model = session.query(Carrier).filter(Carrier.id == id).first()
            if model is None:
                abort(404, message='Carrier {} does not exist'.format(id))
            return marshal(model, organization_fields)
