# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

from flask_restful import fields


register_type = {
    'id': fields.Integer(),
    'code': fields.String(),
    'title': fields.String(),
    'description': fields.String(),
}

organization_fields = {
    'id': fields.Integer(),
    'name': fields.String(),
    'legalName':  fields.String(attribute='legal_name'),

    'registerType':  fields.Nested(register_type, attribute='register_type'),
    'registerNumber':  fields.String(attribute='register_number'),

    'actualAddress':  fields.String(attribute='actual_address'),
    'legalAddress':  fields.String(attribute='legal_address'),
    'timetable':  fields.String(attribute='timetable'),

    'firstName':  fields.String(attribute='first_name'),
    'middleName':  fields.String(attribute='middle_name'),
    'lastName':  fields.String(attribute='last_name'),
}


__all__ = ('register_type', 'organization_fields')
