# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

from flask_restful import abort, fields, marshal, Resource

from travel.rasp.bus.db import session_scope
from travel.rasp.bus.db.models.supplier import Supplier
from travel.rasp.bus.morda_backend.views.organization import organization_fields

supplier_fields = dict(organization_fields, **{
    'code': fields.String(),
    'taxationNumber': fields.String(attribute='taxation_number')
})


class SupplierListRoute(Resource):
    def get(self):
        '''List all suppliers'''
        with session_scope() as session:
            return marshal(session.query(Supplier).all(), supplier_fields)


class SupplierRoute(Resource):
    def get(self, id):
        '''Fetch a supplier given its identifier'''
        with session_scope() as session:
            model = session.query(Supplier).filter(Supplier.id == id).first()
            if model is None:
                abort(404, message='Supplier {} does not exist'.format(id))
            return marshal(model, supplier_fields)
