# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

from flask_principal import Permission, RoleNeed


class Role(object):
    def __init__(self, identifier, name='', help=''):
        self.identifier = identifier
        self.name = name
        self.help = help
        self.permission = Permission(RoleNeed(self.identifier))

    def asdict(self):
        return {
            'name': {'ru': self.name, 'en': self.name},
            'help': {'ru': self.help, 'en': self.help}
        }


class Roles(object):
    def __init__(self):
        self.Admin = Role('Admin', name=u'Администратор', help=u'Полный доступ')
        self.PointMatching = Role('PointMatching', name=u'Редактор матчинга',
                                  help=u'Редактирование матчинга геообъектов')

    def asdict(self):
        return dict([(role_name, role.asdict()) for role_name, role in self.__dict__.items()])

    def all(self):
        return self.__dict__.values()


ROLES = Roles()
