# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

import argparse
import csv
import json
import logging

from travel.rasp.bus.scripts.automatcher import AutoMatcher

if __name__ == '__main__':
    logging.basicConfig()
    log = logging.getLogger()
    log.setLevel(logging.INFO)
    parser = argparse.ArgumentParser(description='Automatcher CLI')
    parser.add_argument('--suppliers', help='list of suppliers, all by default')
    parser.add_argument('--scenarios', help='scenarios to run', required=True)
    parser.add_argument('--params-file', help='JSON file with parameters for scenarios', required=True)
    parser.add_argument('--login', help='Login for logging updates', required=True)
    parser.add_argument('--dry', help='Dry run. No actions in DB.', default=False, action='store_true')
    parser.add_argument('--run-all', help='Dry run of all scenarios extended by matched points',
                        default=False, action='store_true')

    options = parser.parse_args()
    scenarios_names = [sc.strip() for sc in options.scenarios.split(',')] if options.scenarios else []
    suppliers_names = [supplier.strip() for supplier in options.suppliers.split(',')] if options.suppliers else []

    with open(options.params_file, 'r') as f:
        params = json.load(f)

    auto_matcher = AutoMatcher(scenarios_names, suppliers_names, params, options.login, options.dry, options.run_all)
    auto_matcher.run()

    automatcher_stats = auto_matcher.get_stats()
    for report_name, report_rows in automatcher_stats.items():
        report_filename = str('{}.csv'.format(report_name))
        with open(report_filename, 'w') as f:
            csvwriter = csv.writer(f, dialect='excel')
            csvwriter.writerows(report_rows)
