# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

from collections import OrderedDict

from travel.rasp.bus.scripts.automatcher.scenarios.dead_matchings import DeleteDeadMatchings
from travel.rasp.bus.scripts.automatcher.scenarios.etraffic_twins_stations import EtrafficTwinStations
from travel.rasp.bus.scripts.automatcher.scenarios.from_file import MatchingsFromFile
from travel.rasp.bus.scripts.automatcher.scenarios.rasp_data import MatchByRaspData
from travel.rasp.bus.scripts.automatcher.scenarios.unitiki_update import UnitikiPointIdUpdate

SCENARIOS = OrderedDict([
    ('from_file', MatchingsFromFile),
    ('etraffic_twin_stations', EtrafficTwinStations),
    ('unitiki_update', UnitikiPointIdUpdate),
    ('rasp_data', MatchByRaspData),
    ('dead_matchings', DeleteDeadMatchings),
])


def get_scenarios_by_names(scenarios_names, params):
    scenarios_names = set(scenarios_names)
    scenarios = []
    for scenario_name, scenario_cls in SCENARIOS.items():
        if not scenarios_names:
            break
        if scenario_name in scenarios_names:
            scenarios.append(scenario_cls(**params))
            scenarios_names.remove(scenario_name)

    if len(scenarios_names) > 0:
        raise ValueError("unknown scenarios names: {}".format(', '.join(scenarios_names)))
    return scenarios
