# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

import logging

from travel.library.python.dicts.settlement_repository import SettlementRepository
from travel.library.python.dicts.station_repository import StationRepository
from travel.rasp.bus.db.models.matching import PointType, parse_point_key
from travel.rasp.bus.scripts.automatcher.scenarios.base import BaseUnmatcher
from travel.rasp.bus.scripts.automatcher.policy import TypePolicy

log = logging.getLogger(__name__)


class DeleteDeadMatchings(BaseUnmatcher):
    name = 'dead_matchings'
    point_type_policy = TypePolicy.TYPE_STATION
    station_repo = None
    settlement_repo = None

    def __init__(self, **params):
        super(DeleteDeadMatchings, self).__init__(**params)

        log.info('prepare scenario: %s', self.name)
        config = self.get_config(params)

        station_fn = config['station_fn']
        settlement_fn = config['settlement_fn']

        station_repo = StationRepository()
        station_repo.load_from_file(station_fn)

        settlement_repo = SettlementRepository()
        settlement_repo.load_from_file(settlement_fn)

        self.station_repo = station_repo
        self.settlement_repo = settlement_repo

    def _run(self, point):
        point_type, point_id = parse_point_key(point.point_key)
        if point_id is None:
            log.error('error parsing point_key: %s', point.point_key)
            return False, None

        if point_type == PointType.STATION:
            station = self.station_repo.get(point_id)
            if not station:
                return True, None

        if point_type == PointType.CITY:
            settlement = self.settlement_repo.get(point_id)
            if not settlement:
                return True, None
        return False, None
