# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

import csv
import logging

from travel.rasp.bus.scripts.automatcher.scenarios.base import BaseMatcher
from travel.rasp.bus.scripts.automatcher.policy import TypePolicy

log = logging.getLogger(__name__)


class MatchingsFromFile(BaseMatcher):
    """
    format of matchings:
        CSV with 3 columns, delimeter ','
        supplier_code - supplier name, for example - etraffic
        supplier_point_id - supplier point id with buses prefixes
        point_key - point_key to set
    """
    name = 'from_file'
    point_type_policy = TypePolicy.TYPE_ALL

    matchings = None

    def __init__(self, **params):
        super(MatchingsFromFile, self).__init__(**params)

        log.info('prepare scenario: %s', self.name)

        config = self.get_config(params)
        csv_matchings = config['matchings']

        matchings_reader = csv.reader(csv_matchings.splitlines(), dialect='excel')
        raw_matchings = []
        for matching in matchings_reader:
            if len(matching) != 3:
                raise ValueError("Unexpected CSV line format, need 'supplier, point_id, matching', got: %s", matching)
            stripped = [x.strip() for x in matching]
            raw_matchings.append(stripped)

        matchings = {}
        suppliers_to_ids = {}
        suppliers = self.get_suppliers_list()
        for (supplier_id, supplier_name) in suppliers:
            suppliers_to_ids[supplier_name] = supplier_id

        for matching in raw_matchings:
            supplier_name, supplier_point_id, point_key = matching
            if supplier_name not in suppliers_to_ids:
                raise ValueError("unknown supplier name in matchings: {}".format(supplier_name))
            supplier_id = suppliers_to_ids[supplier_name]
            matchings[(supplier_id, supplier_point_id)] = point_key

        self.matchings = matchings

    def _run(self, point):
        key = (point.supplier_id, point.supplier_point_id)
        if key in self.matchings:
            return True, self.matchings[key]
        return False, None
