from travel.rasp.bus.scripts.cache_research.emulator import CacheEmulator
from travel.rasp.bus.scripts.cache_research.warmer import Warmer


class Queue:
    def __init__(self, segments, ttl, norm, log_entries, warmer_config):
        self.main_queue = log_entries
        self.warmer_queue = []
        first_entry_time = None if len(log_entries) == 0 else log_entries[0].datetime
        self.warmer = Warmer(warmer_config, first_entry_time, segments)
        self.cache_emulator = CacheEmulator(first_entry_time, segments, ttl, norm)

    def _next_entry(self):
        if not len(self.main_queue):
            raise StopIteration
        return self.main_queue.pop(0)

    def publish_entry(self):
        entry = self._next_entry()
        self.warmer_queue.extend(self.warmer.run(entry))
        while len(self.warmer_queue) and self.warmer_queue[0][0].datetime < entry.datetime:
            warmer_entry, suppliers = self.warmer_queue.pop(0)
            self.cache_emulator.run(warmer_entry, suppliers)
        self.cache_emulator.run(entry)
