from collections import defaultdict

import requests


REQUEST = 'http://api.bus.yandex.net/rasp/segments'


def filter_segments(segments):
    d = defaultdict(set)
    id_prefix = 'c'
    for segment in segments:
        if segment['fromId'].startswith(id_prefix) and segment['toId'].startswith(id_prefix):
            d[segment['fromId']].add(segment['toId'])
    return d


def get_segments():
    segments = {}
    response = requests.get(REQUEST).json()
    for supplier in response.keys():
        segments[supplier] = filter_segments(response[supplier])
    return segments
