# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

from six import python_2_unicode_compatible


@python_2_unicode_compatible
class SearchResultKey(object):
    def __init__(self, connector, from_point, to_point, when):
        self.connector = connector
        self.from_point = from_point
        self.to_point = to_point
        self.when = when

    def __str__(self):
        return 'task.{}.search:{}:{}:{}'.format(
            self.connector,
            self.from_point,
            self.to_point,
            self.when,
        )

    def __repr__(self):
        return '<SearchResultKey connector={} from_point={} to_point={} when={}/>'.format(
            self.connector,
            self.from_point,
            self.to_point,
            self.when,
        )

    @staticmethod
    def create_by_connector(connector):
        return SearchResultKey(
            connector=connector,
            from_point='*',
            to_point='*',
            when='*',
        )

    @staticmethod
    def create_by_direction(connector, from_point, to_point):
        return SearchResultKey(
            connector=connector,
            from_point=from_point,
            to_point=to_point,
            when='*',
        )

    @staticmethod
    def create_universal_key():
        return SearchResultKey(
            connector='*',
            from_point='*',
            to_point='*',
            when='*',
        )

    @staticmethod
    def parse(raw_key):
        task_info, from_point, to_point, when = raw_key.split(':')
        task_lable, connector, task_type = task_info.split('.')

        assert task_lable == 'task' and task_type == 'search'

        return SearchResultKey(
            connector=connector,
            from_point=from_point,
            to_point=to_point,
            when=when,
        )


@python_2_unicode_compatible
class SegmentsKey(object):
    def __init__(self, connector):
        self.connector = connector

    def __str__(self):
        return 'task.{}.segments'.format(
            self.connector,
        )

    def __repr__(self):
        return '<SegmentKey connector={}/>'.format(self.connector)

    @staticmethod
    def create_universal_key():
        return SegmentsKey(
            connector='*',
        )

    @staticmethod
    def parse(raw_key):
        task_lable, connector, task_type = raw_key.split('.')
        assert task_lable == 'task' and task_type == 'segments'

        return SegmentsKey(
            connector=connector,
        )


@python_2_unicode_compatible
class CalendarKey(object):
    def __init__(self, connector, from_point, to_point, when):
        self.connector = connector
        self.from_point = from_point
        self.to_point = to_point
        self.when = when

    def __str__(self):
        return '{}.calendar:{}:{}:{}'.format(
            self.connector,
            self.from_point,
            self.to_point,
            self.when,
        )

    def __repr__(self):
        return '<CalendarKey connector={} from_point={} to_point={} when={}/>'.format(
            self.connector,
            self.from_point,
            self.to_point,
            self.when,
        )

    @staticmethod
    def create_by_connector(connector):
        return CalendarKey(
            connector=connector,
            from_point='*',
            to_point='*',
            when='*',
        )

    @staticmethod
    def create_by_direction(connector, from_point, to_point):
        return CalendarKey(
            connector=connector,
            from_point=from_point,
            to_point=to_point,
            when='*',
        )

    @staticmethod
    def create_universal_key():
        return CalendarKey(
            connector='*',
            from_point='*',
            to_point='*',
            when='*',
        )
