# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

import argparse
import datetime
import logging

import isodate

from travel.rasp.bus.scripts.carrier_matcher import CarrierMatcher


if __name__ == '__main__':
    logging.basicConfig()
    log = logging.getLogger()
    log.setLevel(logging.INFO)
    parser = argparse.ArgumentParser(description='CarrierMatcher CLI')
    parser.add_argument('--yt-proxy', default='hahn')
    parser.add_argument('--yql-token', default='sec-01d956rm0wknnrbhhjsyx0rh56.sputnik-yql-token')
    parser.add_argument('--suppliers', help='list of suppliers, all if empty')
    parser.add_argument('--interval-end-date', type=isodate.parse_date)
    parser.add_argument('--days_ago_interval', default=3)
    parser.add_argument('--dry', help='Dry run', default=False, action='store_true')

    options = parser.parse_args()
    suppliers = [supplier.strip() for supplier in options.suppliers.split(',')] if options.suppliers else []
    interval_end_date = options.interval_end_date
    if not interval_end_date:
        interval_end_date = (datetime.datetime.utcnow() - datetime.timedelta(days=1))
        interval_end_date = interval_end_date.date()

    carrier_matcher = CarrierMatcher(options.yt_proxy, options.yql_token, suppliers, interval_end_date,
                                     options.days_ago_interval, options.dry)
    carrier_matcher.run()
