# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

import argparse

from travel.library.python.rasp_vault.api import get_secret

from travel.rasp.bus.scripts.endpoints_stats import EndpointsStatistic

if __name__ == '__main__':
    parser = argparse.ArgumentParser(description='Endpoints statistic module')
    parser.add_argument('--yt-token', help='YT token', default='sec-01d956rm0wknnrbhhjsyx0rh56.sputnik-yt-token')
    parser.add_argument('--environment', help='YT environment path, production/testing', default='testing')

    options = parser.parse_args()
    yt_token = get_secret(options.yt_token)

    endpoints_stat = EndpointsStatistic(yt_token, options.environment)
    endpoints_stat.run()
