# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

import argparse
import logging.config

import yenv

from travel.rasp.bus.scripts.endpoints_updater import EndpointsUpdater
from travel.rasp.bus.scripts.library.utils import LOGGING_CONFIG

if __name__ == '__main__':
    parser = argparse.ArgumentParser(description='BusEndpointsUpdater CLI')
    parser.add_argument('--suppliers', help='Comma separated suppliers codes. All if undefined.', default='')
    parser.add_argument('--login', help='Login for matching_point.updated_by', required=True)
    parser.add_argument('--dry', help='Dry run. No actions in DB.', action='store_true')
    parser.add_argument('--force', help='Production fuse.', action='store_true')
    args = parser.parse_args()

    logging.config.dictConfig(LOGGING_CONFIG)

    if yenv.type == 'production' and not args.force and not args.dry:
        logging.error('Use --force or --dry for run in production environment. Exit.')
        exit(1)

    endpoints_updater = EndpointsUpdater()
    supplier_codes = [s.strip() for s in args.suppliers.split(',')] if args.suppliers else None
    endpoints_updater.run(supplier_codes=supplier_codes, login=args.login, dry=args.dry)
