# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

import argparse
import logging.config

from travel.rasp.bus.scripts.library.utils import LOGGING_CONFIG
from travel.rasp.bus.scripts.feeds_updater import FeedsUpdater


if __name__ == '__main__':

    logging.config.dictConfig(LOGGING_CONFIG)
    log = logging.getLogger()
    log.setLevel(logging.INFO)

    parser = argparse.ArgumentParser(description='FeedsUpdater CLI')
    parser.add_argument('--days_count', help='Count of previous days for CPA statistics', default=30)
    parser.add_argument('--orders_threshold', help='Min orders count for direction', default=3)
    parser.add_argument('--default_settlement_image', help='Destination image if no one in region_images', default=None)
    parser.add_argument('--limit', default=10000)
    parser.add_argument('--dry', help='Dry run. Will not upload to s3', default=False, action='store_true')
    options = parser.parse_args()

    FeedsUpdater(
        options.days_count,
        options.orders_threshold,
        options.limit,
        options.default_settlement_image,
        options.dry,
    ).run()
