# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

from logging import INFO

LOGGING_CONFIG = {
    'version': 1,
    'disable_existing_loggers': False,
    'formatters': {
        'application': {
            'class': 'logging.Formatter',
            'format': '%(asctime)s %(name)-15s %(levelname)-8s %(processName)-10s %(message)s'
        },
    },
    'handlers': {
        'application': {
            'class': 'logging.StreamHandler',
            'stream': 'ext://sys.stdout',
            'formatter': 'application'
        },
    },
    'loggers': {
        '': {
            'handlers': ['application'],
            'level': INFO,
        },
    }
}
