# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

import argparse
import logging.config

from travel.rasp.bus.library.locale_setter import RuLocaleHolder
from travel.rasp.bus.scripts.library.utils import LOGGING_CONFIG
from travel.rasp.bus.scripts.order_report import month_report, year_report
from travel.rasp.bus.scripts.order_report.detailed_report import detailed_report


def parse_args():
    parser = argparse.ArgumentParser(description='Create the order report.')
    subparsers = parser.add_subparsers(title='report', dest='cmd')
    year_cmd = subparsers.add_parser('year')
    month_cmd = subparsers.add_parser('month')
    detailed_cmd = subparsers.add_parser('detailed')

    for cmd in (year_cmd, month_cmd, detailed_cmd, ):
        cmd.add_argument(
            '-y',
            '--year',
            help='Report Year',
            required=True,
            type=int,
        )
        cmd.add_argument(
            '-e',
            '--to-email',
            dest='emails',
            help='To emails',
            required=True,
            action='append',
            type=str,
        )

    for cmd in (month_cmd, detailed_cmd, ):
        cmd.add_argument(
            '-m',
            '--month',
            help='Report Month',
            required=True,
            type=int,
        )

    return parser.parse_args()


def main():
    logging.config.dictConfig(LOGGING_CONFIG)
    args = parse_args()

    with RuLocaleHolder():
        if args.cmd == 'year':
            year_report(args.year, args.emails)
        elif args.cmd == 'month':
            month_report(args.year, args.month, args.emails)
        elif args.cmd == 'detailed':
            detailed_report(args.year, args.month, args.emails)


if __name__ == '__main__':
    main()
