# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

import codecs
from datetime import date

import six

if six.PY2:
    from backports import csv
else:
    import csv


def dump_csv(rows):
    out = six.StringIO()
    csv_writer = csv.writer(out, delimiter=';')
    csv_writer.writerows(rows)
    return codecs.BOM_UTF8 + out.getvalue().encode('utf-8')


def get_human_month(month):
    human_month = date(1900, month, 1).strftime('%B')
    return human_month.decode('utf-8') if six.PY2 else human_month
