# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

import argparse
import logging.config

from travel.rasp.bus.scripts.library.utils import LOGGING_CONFIG
from travel.rasp.bus.scripts.pointkey_filter import PointKeyFilterGenerator


if __name__ == '__main__':
    parser = argparse.ArgumentParser(description='PointKeyGenerator CLI')
    parser.add_argument('--stationbin', help='station.bin input path', required=True)
    parser.add_argument('--settlement2stationbin', help='settlement2station.bin input path', required=False)
    parser.add_argument('--settlementbin', help='settlement.bin input path', required=False)
    parser.add_argument('--filterdatamsgpack', help='filterdata.msgpack output path', required=True)
    parser.add_argument('--ttype', help='generates specified tranport type filter', required=False)
    args = parser.parse_args()

    logging.config.dictConfig(LOGGING_CONFIG)

    if args.ttype:
        PointKeyFilterGenerator().gen(
            station_fn=args.stationbin,
            settlement_fn=args.settlementbin,
            pointkey_fn=args.filterdatamsgpack,
            ttype=args.ttype
        )
    else:
        PointKeyFilterGenerator().gen(
            station_fn=args.stationbin,
            station_to_settlement_fn=args.settlement2stationbin,
            pointkey_fn=args.filterdatamsgpack,
        )
