import re

import psycopg2
import psycopg2.extras


def get_order_by_id(conn, id):
    with conn.cursor(cursor_factory=psycopg2.extras.DictCursor) as cur:
        cur.execute(
            "select\n"
            " *\n"
            "FROM\n"
            "    orders\n"
            "WHERE\n"
            "    id=%s",
            (id,)
        )

        rows = cur.fetchall()
        if not len(rows):
            return None
        return rows[0]


FISCAL_URLS_REGEXP = re.compile(r'"fiscal_receipt_url": "(.+)"')
REFUND_ID_REGEXP = re.compile(r'"trust_refund_id": "(.+)"')


def get_refund_check_data_by_order_id(conn, id):
    with conn.cursor(cursor_factory=psycopg2.extras.DictCursor) as cur:
        cur.execute(
            """
            select
                log
            FROM
                orders_log
            WHERE
                id=%s
            """,
            (id,)
        )

        fiscal_urls = set()
        refund_ids = set()
        rows = cur.fetchall()
        for r in rows:
            log_value = r['log']
            for url in FISCAL_URLS_REGEXP.findall(log_value):
                fiscal_urls.add(url)
            for url in REFUND_ID_REGEXP.findall(log_value):
                refund_ids.add(url)

        return fiscal_urls, refund_ids
